#include <p30fxxxx.h>
#include <outcompare.h>

/************************************************************************
*    Function Name:  ConfigIntOC2                                	*
*    Description:    This Function Configures Interrupt and sets        *
*                    Interrupt Priority                                 *
*    Parameters:     unsigned int config                                *
*    Return Value:   None                                               *
************************************************************************/

void ConfigIntOC2(unsigned int config)
{
    IFS0bits.OC2IF = 0;                   /* Clear IF bit */
    IPC1bits.OC2IP = (config &0x0007);    /* Assign Interrupt Priority */ 
    IEC0bits.OC2IE = (config &0x0008)>>3; /* Enable/disable Interrupt */
}
